/*
 * Decompiled with CFR 0.152.
 */
package net.brdle.collectorsreap.common.loot;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import net.brdle.collectorsreap.common.loot.CRLootModifiers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.entries.LootTableReference;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import org.jetbrains.annotations.NotNull;

public class CRFishingLoot
extends LootModifier {
    public static final Supplier<Codec<CRFishingLoot>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> CRFishingLoot.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)Codec.STRING.fieldOf("table").xmap(CRLootModifiers::getLootTableReference, CRLootModifiers::getString).forGetter(m -> m.lootTable), (App)Codec.FLOAT.fieldOf("chance").forGetter(m -> Float.valueOf(m.chance)))).apply((Applicative)inst, CRFishingLoot::new)));
    private static final Field LOOT_FIELD = ObfuscationReflectionHelper.findField(LootContext.class, (String)"f_278466_");
    private final LootTableReference lootTable;
    private final float chance;

    public CRFishingLoot(LootItemCondition[] conditions, LootTableReference lootTable, float chance) {
        super(conditions);
        this.lootTable = lootTable;
        this.chance = chance;
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        try {
            Set set = Collections.unmodifiableSet((Set)LOOT_FIELD.get(context));
            if (set.isEmpty() && context.m_230907_().m_188501_() <= this.chance) {
                ObjectArrayList loot = ObjectArrayList.of();
                this.lootTable.m_6948_(arg_0 -> ((ObjectArrayList)loot).add(arg_0), context);
                return loot;
            }
            return generatedLoot;
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new RuntimeException("Collector's Reap fishing loot table error", e);
        }
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return (Codec)CRLootModifiers.FISHING.get();
    }
}

